<?php

$maxImageSize = setting('_general.max_image_size');

return [
    'id'        => 'courses',
    'name'      => __('Courses'),
    'icon'      => '<i class="icon-gift"></i>',
    'tab'       => "Common",
    'fields'    => [
        [
            'id'            => 'select_verient',
            'type'          => 'select',
            'class'         => '',
            'label_title'   => __('Style variation'),
            'options'       => [
                ''                          => __('Classic'),
                'am-courses-block-two'      => __('Traditional'),
                'am-courses-block-three'    => __('Modern'),
            ],
            'default'       => '',
        ],
        [
            'id'            => 'section_title_variation',
            'type'          => 'select',
            'class'         => '',
            'label_title'   => __('Section title variation'),
            'options'       => [
                'am-section_title_one'      => __('Classic'),
                'am-section_title_two'      => __('Traditional'),
                'am-section_title_three'    => __('Modern'),
            ],
            'default'       => '',
        ],
        // [
        //     'id'            => 'enable_slider',
        //     'type'          => 'radio',
        //     'class'         => '',
        //     'label_title'   => __('Enable Slider'),
        //     'options'       => [
        //         'yes'   => __('Yes'),
        //         'no'    => __('No'),
        //     ],
        //     'default'       => 'yes',  
        // ],
        [
            'id'            => 'pre_heading_text_color',
            'type'          => 'colorpicker',
            'value'         => '',
            'class'         => '',
            'label_title'   => __('Pre heading text color'),
            // 'field_desc'    => __('settings.pre_heading_text_color_desc'),
        ],
        [
            'id'            => 'pre_heading_bg_color',
            'type'          => 'colorpicker',
            'value'         => '',
            'class'         => '',
            'label_title'   => __('Pre heading bg color'),
            // 'field_desc'    => __('settings.pre_heading_text_color_desc'),
        ],
        [
            'id'            => 'pre_heading',
            'type'          => 'text',
            'value'         => '',
            'class'         => '',
            'label_title'   => __('Pre Heading'),
            'placeholder'   => __('Enter pre heading'),
        ],
        [
            'id'            => 'heading',
            'type'          => 'text',
            'value'         => '',
            'class'         => '',
            'label_title'   => __('Heading'),
            'placeholder'   => __('Enter heading'),
        ],
        [
            'id'            => 'paragraph',
            'type'          => 'editor',
            'value'         => '',
            'class'         => '',
            'label_title'   => __('Description'),
            'placeholder'   => __('Enter description'),
        ],
        [
            'id'            => 'courses_limit',
            'type'          => 'text',
            'value'         => '',
            'class'         => '',
            'label_title'   => __('Courses limit'),
            'placeholder'   => __('Enter courses limit'),
        ],
        [
            'id'            => 'first_shape_image',
            'type'          => 'file',
            'class'         => '',
            'label_title'   => __('First shape image'),
            'label_desc'    => __('Add image'),
            'max_size'      => $maxImageSize ?? 5,               
            'ext'    => [
                'jpg',
                'png',
                'svg',
                'jpeg',
                'webp',
            ], 
        ],
        [
            'id'            => 'second_shape_image',
            'type'          => 'file',
            'class'         => '',
            'label_title'   => __('Second shape image'),
            'label_desc'    => __('Add image'),
            'max_size'      => $maxImageSize ?? 5,               
            'ext'    => [
                'jpg',
                'png',
                'svg',
                'jpeg',
                'webp',
            ], 
        ],
        [
            'id'            => 'third_shape_image',
            'type'          => 'file',
            'class'         => '',
            'label_title'   => __('Third shape image'),
            'label_desc'    => __('Add image'),
            'max_size'      => $maxImageSize ?? 5,               
            'ext'    => [
                'jpg',
                'png',
                'svg',
                'jpeg',
                'webp',
            ], 
        ],
    ]
];
